/*++++ FILE DESCRIPTION ++++++++++++++++++++++++++++++++++++++++++++++++++++++

project                 AMMOS GX40x

@file                   $Workfile: rs_gx40x_global_frame_types_if_defs.h $
@copyright              (c) 2002 Rohde & Schwarz, Munich
@version                $Revision: 3 $

@author                 $Author: Hisch_m $

@responsible            G. Condra

@language               ANSI-C

compiler                ANSI C conform

@description            This file contains and enumeration of the possible 
                        data stream types

@see

------ End of file description ---------------------------------------------*/

#ifndef _RS_GX40X_GLOBAL_FRAME_TYPES_IF_DEFS_H
#define _RS_GX40X_GLOBAL_FRAME_TYPES_IF_DEFS_H

#ifdef __cplusplus
extern "C" {
#endif

/*++++ GLOBAL TYPES DECLARATION ++++++++++++++++++++++++++++++++++++++++++++*/

/** Enumeration of the possible data stream types */
enum eFRH_DATASTREAM__TYPES
{
  /** Type for test data */
  ekFRH_DATASTREAM__TEST_DATA                         = 0x00,   /**< TBD */

  /** Type for IF data 32Bit Real- and 32Bit Imaginary-part, fixed point, not rescaled */
  ekFRH_DATASTREAM__IFDATA_32RE_32IM_FIX              = 0x01,   /**< IF data : struct < typIFD_IFDATA_FRAME */

  /** Type for IF data 16Bit Real- and 16Bit Imaginary-part, fixed point, not rescaled */
  ekFRH_DATASTREAM__IFDATA_16RE_16IM_FIX              = 0x02,   /**< IF data : struct < typIFD_IFDATA_FRAME */

  /** Type for IF data 16Bit Real-part, two samples for each word, fixed point, not rescaled */
  ekFRH_DATASTREAM__IFDATA_16RE_16RE_FIX              = 0x03,   /**< IF data : struct < typIFD_IFDATA_FRAME */

  /** Type for IF data 32Bit Real- and 32Bit Imaginary-part, fixed point, rescaled */
  ekFRH_DATASTREAM__IFDATA_32RE_32IM_FIX_RESCALED     = 0x04,   /**< IF data : struct < typIFD_IFDATA_FRAME */

  /** Type for IF data 32Bit Real- und 32Bit Imaginary-part, floating point, rescaled */
  ekFRH_DATASTREAM__IFDATA_32RE_32IM_FLOAT_RESCALED   = 0x05,   /**< IF data : struct < typIFD_IFDATA_FRAME */

  /** Type for Spectrum-data 8Bit */
  ekFRH_DATASTREAM__SPECDATA_8BIT                     = 0x10,   /**< TBD */

  /** Type for Spectrum-data 16Bit */
  ekFRH_DATASTREAM__SPECDATA_16BIT                    = 0x11,   /**< TBD */

  /** Type for Spectrum-data 32Bit */
  ekFRH_DATASTREAM__SPECDATA_32BIT                    = 0x12,   /**< TBD */

  /** Type for Spectrum-data 32Bit float */
  ekFRH_DATASTREAM__SPECDATA_FLOAT                    = 0x13,   /**< Spectrum data : struct < typSPECDATA_FLOAT */

  /* * Data stream types for Tuner HF (EM010) data */
  ekFRH_DATASTREAM__HF_TUNING_INDICATOR_DATA          = 0x20,   /**< Tuning Indicator data : struct < struEM010_HF_TUNING_INDICATOR_AND_STATUS_DATA*/

  ekFRH_DATASTREAM__HF_SCF_DATA                       = 0x22,   /**< Scan Channel Found : struct < struEM010_HF_SCAN_CHANNEL_FOUND */   

  ekFRH_DATASTREAM__HF_SFF_DATA                       = 0x23,   /**< Scan Frequency Found : struct < struEM010_HF_SCAN_FREQUENCY_FOUND */

  ekFRH_DATASTREAM__HF_SSR_DATA                       = 0x24,   /**< Scan Sweep Restarted : struct < struEM010_HF_SCAN_RESTARTED */

  /* * Types for HF Single Channel Demodulation*/
  ekFRH_DATASTREAM__DEMOD_HF_SYMBOLSTREAM_DATA        = 0x30,   /**< HF Demod data (symbol stream) : struct < struDEMOD_HF_SYMBOL_DATA*/

  /* * Types for HF Single Channel Decoding*/
  ekFRH_DATASTREAM__DECODER_TEXT_DATA                 = 0x40,   /**< Decoded text data : struct < struDECODER__DECODED_TXT*/

  /* * Decoded graphics data */
  ekFRH_DATASTREAM__DECODER_GRAPHIC_DATA              = 0x41,   /**< Decoded graphic data : struct < struDECODER__DECODED_GRAPHICS*/

  /* * Types for HF SingleChannel Realtime Visualisation*/
  ekFRH_DATASTREAM__VISUALISATION_HF_SPECTRUM_DATA    = 0x50,   /**< RTVIS spectrum data : struct < struVISUALISATION_HF_SPECTRUM_DATA*/

  ekFRH_DATASTREAM__VISUALISATION_HF_TIMEDOMAIN_DATA  = 0x51,   /**< RTVIS timedomain data : struct < struVISUALISATION_HF_TIMESIGNAL_DATA*/

  /** Type audio data */
  ekFRH_DATASTREAM__AUDIODATA                         = 0x100,  /**< Audio data : struct < typAUDIODATAFRAME */

  /** Type signal emissions list data */
  ekFRH_DATASTREAM__EMISSION_LIST_DATA                = 0x110,  /**< Signal emission list data : struct < typEMISSION_LIST_FRAME */

  /** Type level indicator data */
  ekFRH_DATASTREAM__LEVELDATA                         = 0x120,  /**< Level indicator data : struct < typLEVELDATA_FRAME */

  /* Enumeration to be extended as new data stream types are identified... */
};

/*---- End of global types declaration -------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* ifndef for file (multi)inclusion lock */
/***** End of File ***********************************************************/
